from graphics import Canvas
import time

WAND_WIDTH = 5
WAND_HEIGHT = 50

SPARKLE_RADIUS = 5
SPARKLE_Y_VEL = 10

DELAY = 1 / 60


def main():
    canvas = Canvas()
    width = canvas.get_width()
    height = canvas.get_height()

    # create wand and sparkles
    wand = canvas.create_rectangle(0, 0, WAND_WIDTH, WAND_HEIGHT)
    sparkles = []

    while True:
        # bottom right of wand is attached to mouse
        wand_left_x = canvas.get_mouse_x() - WAND_WIDTH
        wand_top_y = canvas.get_mouse_y() - WAND_HEIGHT
        canvas.moveto(wand, wand_left_x, wand_top_y)

        # move down all the existing sparkles
        for sparkle in sparkles:
            canvas.move(sparkle, 0, -SPARKLE_Y_VEL)

        # new sparkle
        sparkle = canvas.create_oval(wand_left_x + WAND_WIDTH / 2 - SPARKLE_RADIUS, wand_top_y - SPARKLE_RADIUS,
                                     wand_left_x + WAND_WIDTH / 2 + SPARKLE_RADIUS, wand_top_y + SPARKLE_RADIUS,
                                     'yellow')
        sparkles.append(sparkle)

        time.sleep(DELAY)
        canvas.update()


if __name__ == '__main__':
    main()